"""
Display the page computation time.
"""
import time
import hooks

@hooks.add_to("url", before="**")
def start(dummy_context, server):
    server.start_time = time.time()

@hooks.add_to("url", after="**", always=True)
def stop(dummy_context, server):
    server.write("/* Page generation: %g ms */" % (
        1000*(time.time() - server.start_time)))
