"""
Add an exit HTTP server functionality.
"""
import sys
import hooks

@hooks.add_to("url")
def stop(context, server):
    if server.path == '/stop':
        context.run_server = False
        server.write("Bye Bye")
        context.real_server.hooks_running = False
        return True

@hooks.add_to("menu", after="*")
def stop_menu(dummy_context, html):
    html.append('<li><a href="/stop">Exit</a>')

