"""
Define an HTTP session
"""

import random
import time
import hooks

url = hooks.get("url")

sessions = {}

@url.add(before='**', after='HTTP.fy_profiling:start')
def before(context, server):
    cookies = server.headers.get('Cookie')
    if cookies:
        for session in cookies.split(";"):
            session = session.split("=")[1]
            if session in sessions:
                before.saved_dict = context.__dict__
                context.__dict__ = sessions[session]
                return
    before.saved_dict = None
    session = str((time.time()-int(time.time()),
                   random.randrange(0, 1e9),
                   id(server.wfile)))
    sessions[session] = context.__dict__.copy()
    server.send_response(307)
    server.send_header('Set-Cookie', 'SESSION=%s' % session)
    server.send_header('Location', context.top + server.path)
    server.end_headers()
    return True

@url.add(after="HTTP.fy_http", always=True)
def after(context, dummy_server):
    if before.saved_dict:
        context.__dict__ = before.saved_dict
