"""
Home page with all the hooks defined.
"""
import hooks

@hooks.add_to("menu")
def menu(dummy_context, html):
    html.append('<li><a href="/hooks">Explore current hooks</a>')

def display_hooks(context, server):
    t = context.Translator(server.translate)
    t.append_raw('<table border><tr><th>Hook name<th>Functionality<th>Args<th>Comment</tr>')
    for name in hooks.hooks.hooks:
        hook = hooks.get(name)
        t.append_raw("<tr><td>")
        t.append(name)
        t.append_raw("<td>")
        t.append(hook.functionality)
        t.append_raw("<td>")
        t.append(str(hook.args))
        t.append_raw("<td>")
        t.append(hook.documentation.replace("\n", "<br>"))
        t.append_raw("</tr>")
    t.append_raw("</table>")
    server.write('\n'.join(t))

@hooks.add_to("url")
def url_hooks(context, server):
    server.display_hooks = display_hooks
    if server.path != '/hooks':
        return
    server.write(server.eval_menu())
    display_hooks(context, server)
    return True
