"""
Define the home page with a menu on the left defined by 'menu' hook
and the page content define by the 'home' hook.
"""
import types
import hooks

home = hooks.new("home",
                 "Append HTML home content into translator",
                 args=('context', 'translator')
)
menu = hooks.new("menu",
                 "Append HTML menu content into translator",
                 args=('context', 'translator')
)

@hooks.add_to("url", before="**")
def add_eval_menu(context, server):
    # Update the class each time.
    def eval_menu(dummy_self):
        html = context.Translator(server.translate)
        menu(context, html)
        return '\n'.join(html)
    server.eval_menu = types.MethodType(eval_menu, server)

@hooks.add_to("url")
def home_page(context, server):
    if server.path != '/':
        return
    server.write(server.eval_menu())
    html = context.Translator(server.translate)
    home(context, html)
    server.write('\n'.join(html))
    return True

@menu.add(before="**")
def menu_start(dummy_context, html):
    html.append_raw('<div class="menu">')
    html.append('<a href="/">Home</a>')

@menu.add(after="**")
def menu_last(dummy_context, html):
    html.append_raw('</div><div class="heart">')

@hooks.add_to("css")
def home_css(dummy_context, css):
    css.append(".menu { border:1px solid black; width: 14em; position: fixed}"
               ".heart { margin-left: 15em; }"
               "BODY { margin-top: 0em }"
               "H1 { margin-top: 0px }")
