"""
Display the help message on the home page.
"""
import hooks

@hooks.add_to("menu", after="HTTP.fy_http_hooks")
def menu(dummy_context, html):
    html.append('<li><a href="/help">Display help</a>')

@hooks.add_to("url")
def display_help(context, server):
    if not server.path.startswith("/help"):
        return
    server.write(server.eval_menu())
    messages = context.Translator(server.translate)
    hooks.get('help')(context, messages)
    server.write('<h1>Command line help page</h1>'
                 + ''.join(messages).replace('\n','<br>')
                 + '<br><br>')
    return True
