"""
Add a source column on the page displaying functionalities.
"""
import hooks

def source(fy):
    if '/' in fy:
        return ''
    f = open(fy.replace('.','/') + '.py', 'r')
    code = f.read()
    f.close()
    return code

@hooks.add_to("url")
def url_source(dummy_context, server):
    fy = server.get_parameter('/source/')
    if not fy:
        return
    server.write(server.eval_menu())
    try:
        from pygments import highlight
        from pygments.lexers import PythonLexer
        from pygments.formatters import HtmlFormatter
        server.write(highlight(source(fy), PythonLexer(),
                               HtmlFormatter(noclasses=True)))
    except ImportError:
        server.write("<p><b>Need the pygments python module</b><p>"
                     + server.escape(source(fy)))
    return True

@hooks.add_to("fy_http_columns")
def source_column(context, server):
    t = context.Translator(server.translate)
    t.append('Src')
    for fy in server.functionality_list[1:]:
        t.append('<a href="/source/{}">{:>3}</a>', fy, source(fy).count('\n'))
    server.html_columns.append(t.content)
