"""
Display details about a functionality.
"""
import hooks

@hooks.add_to("url", after="HTTP.fy_http_fy")
def functionality(context, server):
    fy = server.get_parameter('/functionalities/')
    if not fy:
        return
    server.display_functionalities(context, server)
    t = context.Translator(server.translate)
    t.append_raw('<table border>')
    t.append_raw('<tr><th>Hook name<th>Function<th>Before<th>After<th>Priority<th>Always')
    for hook, fcts in hooks.functionalities()[fy]:
        hook.sort()
        for fct in fcts:
            t.append_raw('<tr><td>')
            t.append(hook.name)
            t.append(fct.html())
    t.append_raw("</table>")
    server.write('\n'.join(t))
    return True

