"""
Interactively change the function order in a hook.
"""
import hooks

@hooks.add_to("fy_hooks_columns", after="HTTP.fy_hooks")
def add_change_order_column(dummy_context, server):
    server.hooks_columns.append(
        ['Move']
        + ['<a href="?change_order=-/%s/%s/%s">&uarr;</a>'
           '<a href="?change_order=+/%s/%s/%s">&darr;</a>'
           % (server.hook.name, f.functionality, f.name,
              server.hook.name, f.functionality, f.name)
           for f in server.function_list[1:]])

@hooks.add_to("url", before="HTTP.fy_fy_toggle")
def change_order(dummy_context, server):
    if '?change_order=' not in server.path:
        return
    server.path, move = server.path.split("?change_order=")
    move = move.split('/')
    hooks.get(move[1]).change_order(move[2], move[3], move[0])
