"""
List the instances of one class
"""
import gc
from . import objgraph
import hooks

@hooks.add_to("url")
def html_gc(context, server):
    class_name = server.get_parameter('/gc/')
    if not class_name:
        return
    server.write(server.eval_menu())
    gc.collect()
    html = context.Translator(server.translate)
    html.append("Click on the object to see informations about it\n")
    html.append_raw("<pre>")
    for obj in objgraph.by_type(class_name):
        html.append(
            '<a href="/about/%s">' % id(obj)
            + server.escape(str(obj)[:80].replace('\n', '\\n'))
            + '</a>\n')
    html.append_raw("\n\n\n</pre>")
    server.write(''.join(html))
    return True

about = hooks.new("about",
                  "Functions append information in html about the object.",
                  args=("context", "server", "obj", "html")
              )

@hooks.add_to("url")
def html_about(context, server):
    obj_id = server.get_parameter('/about/')
    if not obj_id:
        return
    server.write(server.eval_menu())
    html = context.Translator(server.translate)
    obj = objgraph.at(int(obj_id))
    about(context, server, obj, html)
    server.write("".join(html))
    return True

@hooks.add_to("translator_html", after="HTTP.fy_tr_link")
def add_link(dummy_context, translator):
    if translator.text in getattr(translator.server, 'class_names', ()):
        translator.text = '<a href="/gc/%s">%s</a>' % (translator.text,
                                                       translator.text)
        
@hooks.add_to("args")
def args(context):
    class_name = context.extract_arg("--gc=")
    if not class_name:
        return
    print("List of the instances of %s" % class_name)
    gc.collect()
    for obj in objgraph.by_type(class_name):
        print(repr(obj) + ' ' + repr(str(obj))[:50])

@hooks.add_to("help")
def help(dummy_context, messages):
    messages.append("--gc=class: Display the instances of the class")
