"""
List the classes in memory
"""
import gc
from . import objgraph
import hooks

@hooks.add_to("menu")
def menu(dummy_context, html):
    html.append('<li><a href="/gc/">Objects in memory</a>')

@hooks.add_to("url")
def url(context, server):
    if server.path != '/gc/':
        return
    server.write(server.eval_menu())
    gc.collect()
    messages = context.Translator(server.translate)
    messages.append_raw('<h1>Objects in memory</h1>')
    messages.append_raw('<table><tr><th>#Instances<th>Class name</tr>')
    server.class_names = set()
    for name, nr in objgraph.most_common_types(limit=1000):
        server.class_names.add(name)
        messages.append_raw('<tr><td style="text-align:right">%d<td>' % nr)
        messages.append(name)
        messages.append_raw('</tr>')
    messages.append_raw('</table><br><br>')
    server.write(''.join(messages))
    return True

@hooks.add_to("args")
def args(context):
    if context.extract_arg("--gc"):
        print("List of objects in memory")
        for name, nr in objgraph.most_common_types(limit=1000):
            print('%6d %s' % (nr, name))

@hooks.add_to("help", after="fy_debug")
def help(dummy_context, messages):
    messages.append("--gc: Display the number of instances of each class")
