"""
Add a calculator on the web page
"""
try:
    import urllib.request as urllib2
except ImportError:
    import urllib2
import hooks

@hooks.add_to("menu", after="HTTP.fy_http_hooks")
def menu(dummy_context, html):
    html.append('<li><a href="/calculator">Calculator</a>')

@hooks.add_to("url")
def url(context, server):
    if not server.path.startswith("/calculator"):
        return
    if server.path != '/calculator':
        f = urllib2.unquote(server.path.split('/calculator/')[1])
        server.write(str(context.calc_eval(f))
                     + '<p style="font-size:70%">')
        return True
    server.write(server.eval_menu())
    messages = context.Translator(server.translate)
    messages.append("Enter your formula:")
    messages.append_raw('<input onkeyup="calc_eval(event)"><p>')
    messages.append("The answer:")
    messages.append_raw('<iframe id="calc_result"></iframe><hr>')
    server.write('<br>'.join(messages))
    return True

@hooks.add_to("js")
def javascript(context, js):
    js.append("""
function calc_eval(event)
{
var value = (event || window.event).target.value ;
var iframe = document.getElementById('calc_result') ;
iframe.src = "%s/calculator/" + value ;
}
""" % context.top)
