"""
Qt interface for the calculator
"""
import sys
import hooks

def calc(context):
    from PyQt4 import QtCore, QtGui
    class StartQT4(QtGui.QWidget):
        def __init__(self, parent=None):
            super(StartQT4, self).__init__()
            self.b_exit = QtGui.QPushButton('Exit')
            self.b_exit.clicked[bool].connect(self.do_exit)
            self.b_input = QtGui.QLineEdit()
            self.b_input.textChanged[str].connect(self.input)
            self.b_output = QtGui.QLabel()
            self.table = QtGui.QVBoxLayout(self)
            self.table.addWidget(QtGui.QLabel("Enter formula:"))
            self.table.addWidget(self.b_input)
            self.table.addWidget(QtGui.QLabel("Result:"))
            self.table.addWidget(self.b_output)
            self.table.addWidget(self.b_exit)
        def do_exit(self):
            context.calc_qt = False
            QtGui.QApplication.quit()
        def input(self, text):
            self.b_output.setText(repr(context.calc_eval(str(text))))

    app = QtGui.QApplication(sys.argv)
    myapp = StartQT4()
    myapp.show()
    app.exec_()

@hooks.add_to("args", before="STDIN.fy_calc_stdin")
def args(context):
    if context.extract_arg('--calc-qt'):
        hooks.add_to("thread", calc)

@hooks.add_to("help", after="CALC.fy_calc")
def help(dummy_context, messages):
    messages.append(
        "--calc-qt: Qt interface to the calculator")
