#include <stdio.h>

typedef void *(*HookFct)() ; // return NULL to continue
typedef struct hook Hook ;

typedef struct {
  HookFct fct ;
  const char *name ;
  const char *doc ;
  const char *before ;
  const char *after ;
  const char *src_file ;
  const char *src_line ;
  Hook *hook ;
  // computed
  int priority ; // small = before the others
  int done ;
} Function ;

struct hook {
  const char *name ;
  const char *doc ;
  int nr_functions ;
  Function *functions ;
  const char *src_file ;
  const char *src_line ;
  void* (*eval)(Hook*, void*) ;
  Hook *next ;
  // computed
  int is_sorted ;
  Function **sorted ;
} ;

Hook* hook_get(const char *name) ;

#define GUILLEMET(X) #X

Hook* hook_new(const char *name, const char *doc, void* (*eval)(Hook*, void*),
	       const char *src_file, const char *src_line) ;
#define HOOK_NEW(name, doc, eval) hook_new(name, doc, eval, __FILE__, GUILLEMET(__LINE__))

void hook_add(Hook *hook, HookFct fct, const char *doc, const char *before_fy,
	      const char *after_fy, const char *fct_name,
	      const char *src_file, const char *src_line) ;
#define HOOK_ADD(name, fct, doc, before_fy, after_fy) hook_add(name, fct, doc, before_fy, after_fy, #fct, __FILE__, GUILLEMET(__LINE__))

void* hook_call(Hook *h, void *context) ;

void **get_data(const char *name) ;

void* hook_eval(Hook *h, void *context) ;

void hooks_display(FILE *f) ;
