#include <string.h>
#include "hooks.h"
#include "fy_args.h"

static int find(Fy_args *args, const char *arg)
{
  int i ;
  for(i=1; i<args->argc; i++)
     if ( strcmp(args->argv[i], arg) == 0 )
        return i ;
  return 0 ;
}

static void remove_arg(Fy_args *args, int i)
{
  memmove(&args->argv[i], &args->argv[i]+1,
          (args->argc-i-1)*sizeof(*args->argv) ) ;
  args->argc-- ;
}

static void* display(Fy_args *args)
{
  args->find = find ;
  args->remove = remove_arg ;
  int i = args->find(args, "--args") ;
  if ( i )
    {
       int j ;
       for(j=0; j<args->argc; j++)
          printf("arg[%d] = %s\n", j, args->argv[j]) ;
       args->remove(args, i) ;
    }
  return NULL ;
}

#define HELP "--args: Display command line arguments"

static void* message()
{
  return HELP ;
}

void fy_init()
{
  Hook *args = HOOK_NEW("args", "Parse arguments", hook_eval) ;
  HOOK_ADD(args, display, HELP, "***", "") ;
  HOOK_ADD(hook_get("help"), message, HELP, "", "") ;
}

