"""
Read lines from the standard input and broadcast them on the 'stdin' hook.

"""
import asyncio
import sys
import hooks

def read_stdin(context):
    loop = asyncio.get_event_loop()
    reader = asyncio.StreamReader()
    reader_protocol = asyncio.StreamReaderProtocol(reader, loop=loop)
    yield from loop.connect_read_pipe(lambda: reader_protocol, sys.stdin)
    while True:
        line = yield from reader.readline()
        if line == b'':
            print("Async stdin line reader closed")
            return
        hooks.get("stdin")(context, line.strip().decode('utf-8'))

@hooks.add_to("args", after="*")
def args(context):
    if context.extract_arg('--async-stdin2'):
        hooks.add_to("asyncio", read_stdin)

@hooks.add_to("help")
def help(dummy_context, messages):
    messages.append(
        "--async-stdin2: read line from stdin and send them to stdin readers")
