"""
Read lines from the standard input and broadcast them on the 'stdin' hook.

"""
import asyncio
import sys
import hooks

_STDIN_EOF = asyncio.Event()

def wait_for_stdin_eof(context):
    "Ensure that the event loop waits for EOF"
    for i in _STDIN_EOF.wait():
        yield i

@hooks.add_to("args", after="*")
def args(context):
    if context.extract_arg('--async-stdin'):
        def reader(*args):
            line = sys.stdin.readline()
            if line == '':
                asyncio.get_event_loop().remove_reader(sys.stdin.fileno())
                _STDIN_EOF.set()
                print("Async stdin line reader closed")
            else:
                hooks.get("stdin")(context, line.strip())
        asyncio.get_event_loop().add_reader(sys.stdin.fileno(), reader)
        hooks.add_to("asyncio", wait_for_stdin_eof)

@hooks.add_to("help")
def help(dummy_context, messages):
    messages.append(
        "--async-stdin: read line from stdin and send them to stdin readers")
