#!/usr/bin/env python

import hooks

init = hooks.new(
    "init",
    "Initialisation of the application.\n"
    "The argument list is not parsed.",
    args=('context',)
)

args = hooks.new(
    "args",
    "Parse command line arguments.\n"
    "Argument are taken by context.extract_arg method.\n"
    "It is required to have parameters as: --foo=5 and not --foo 5\n"
    "When a matching argument is found, you registered this in the context.",
    args=('context',)
)

action = hooks.new(
    "action",
    "Perform the actions activated in the context.",
    args=('context',)
)

hooks.load_functionalities('fy_*.py')
hooks.load_functionalities('[B-Z]*/fy_*.py') # Do not load ASYNCIO
try:
    import asyncio
    hooks.load_functionalities('ASYNC/fy_*.py')
except ImportError:
    pass

class Context(object):
    def __init__(self):
        import sys
        self.args = list(sys.argv)
    def extract_arg(self, prefixes):
        """Remove the option from the argument list.
        The 'prefixes' may be equal to:
             * ('-h', '--help')
             * '-x'
             * '--value='
           The return value is False or the argument value or True.
        """
        if isinstance(prefixes, str):
            prefixes = (prefixes, )
        for arg in self.args[1:]:
            for prefix in prefixes:
                if arg.startswith(prefix):
                    if prefix.endswith('='):
                        value = arg[len(prefix):]
                    else:
                        if arg != prefix:
                            continue
                        value = True
                    self.args.remove(arg)
                    return value
        return False

context = Context()
init(context)
args(context)
action(context)
