#!/usr/bin/python
"""
Rename the functionality in all the files
"""
import os
import hooks

@hooks.add_to("args", after="*")
def args(context):
    while True:
        rename = context.extract_arg('--rename=')
        if not rename:
            return
        old, new = rename.split(':')
        os.rename(old, new)
        old = old[:-3].replace(os.path.sep, '.')
        new = new[:-3].replace(os.path.sep, '.')
        for dirpath, dummy_dirnames, filenames in os.walk("."):
            for filename in filenames:
                if not filename.endswith('.py'):
                    continue
                filename = os.path.join(dirpath, filename)
                f = open(filename, "r")
                c = f.read()
                d = c.replace('"' + old + '"', '"' + new + '"'
                          ).replace("'" + old + "'", "'" + new + "'"
                          ).replace('"' + old + ':', '"' + new + ':'
                          ).replace("'" + old + ":", "'" + new + ":"
                                    )
                f.close()
                if c != d:
                    f = open(filename, "w")
                    f.write(d)
                    f.close()

@hooks.add_to("help")
def help(dummy_context, messages):
    messages.append(
        "--rename=old.py:new.py rename the source file and update source code")
