"""
Add the 'exit' hook
"""
import atexit
import hooks

@hooks.add_to("init")
def init(context):
    exit_hook = hooks.new("exit", "Called on program exit.",
                          args=("context",))
    atexit.register(exit_hook, context)

