"""
Default running argument:
 * command line option to save them
 * display them on the home page
"""
import os
import ast
import hooks

def read_defaults(context):
    if os.path.exists(context.defaults_name):
        f = open(context.defaults_name, "r")
        c = f.read()
        f.close()
        return c

@hooks.add_to("args", before="fy_help")
def save_as_defaults(context):
    context.defaults_name = context.args[0] + '.default'
    if context.extract_arg('--save-as-default'):
        c = context.args[1:]
        f = open(context.defaults_name, "w")
        f.write(repr(c))
        f.close()
        print("Default args defined: %s" % c)
        return
    defaults = read_defaults(context)
    if defaults:
        context.args += ast.literal_eval(defaults)

@hooks.add_to("help")
def help(dummy_context, messages):
    messages.append(
        "\n"
        "Miscelanous functionalities:\n"
        "--save-as-default to save the current arguments as the default ones")

@hooks.add_to("home", after="HTTP.fy_home_content")
def home(context, html):
    defaults = read_defaults(context)
    if defaults:
        html.append("<p>Default running arguments: <tt>%s</tt></p>" % defaults)
    else:
        html.append(
            "<p>No default arguments, use --save-as-default to set them.</p>")
