"""
Count the number of char, words and lines from the standard input
"""
import hooks

@hooks.add_to("args")
def enable_wc(context):
    if context.extract_arg('--wc-stdin'):
        context.wc = [0,0,0]
        @hooks.add_to("stdin")
        def stdin(context, line):
            context.wc[0] += len(line)
            context.wc[1] += len([i for i in line.split(" ") if i])
            context.wc[2] += 1

        @hooks.add_to("exit")
        def exit(context):
            print(" ".join(str(i) for i in context.wc))

@hooks.add_to("help")
def help(dummy_context, messages):
    messages.append("--wc-stdin: add letters, words and lines counter to stdin")
