"""
Read lines from the standard input and broadcast them on the 'stdin' hook.
"""
import sys
import hooks

stdin = hooks.new(
    "stdin",
    "The hook is called for each readed line.",
    args=('context', 'line')
)

@hooks.add_to("args", after="*")
def args(context):
    if context.extract_arg('--sync-stdin'):
        while True:
            line = sys.stdin.readline()
            if line == '':
                break
            stdin(context, line)

@hooks.add_to("help")
def help(dummy_context, messages):
    messages.append(
        "\n"
        "Stdin analysers:\n"
        "--sync-stdin: read line from stdin and send them to stdin readers")

