"""
Change the top base URL of the web server
"""
import hooks

@hooks.add_to("translator_html", after="**")
def tr_top(context, translator):
    translator.text = translator.text.replace('href="/',
                                              'href="%s/' % context.top
                                          ).replace('src="/',
                                                    'src="%s/' % context.top
                                                )

@hooks.add_to("args")
def option_server_top(context):
    context.top = context.extract_arg("--top=") or ''

@hooks.add_to("help", after="HTTP.fy_http")
def server_top_help(dummy_context, messages):
    messages.append("--top=FOO: append FOO before base URL")
