"""
If a A tag link to the current page: highlight it
"""
import hooks

@hooks.add_to("translator_html", after="HTTP.fy_tr_link")
def tr_highlight(dummy_context, translator):
    path = translator.server.path.split('?')[0]
    a = translator.text.split('<a ')
    for i in range(1, len(a)):
        href = a[i].split('href="')[1].split('"')[0]
        if path == href or path.startswith(href+'/'):
            a[i] = 'class="selected" ' + a[i]
    translator.text = '<a '.join(a)

hooks.get("css").add(lambda c, css: css.append(".selected {background:#FF0}"))

