"""
Add HTML tag TT to all dotted words in the HTML output.
"""
import re
import hooks

@hooks.add_to("translator_html")
def tr_dotted(context, translator):
    if getattr(context, 'no_tr_dotted', False):
        return
    translator.text = re.sub(
        r"( )([a-zA-Z]+\.[.a-zA-Z_]*[a-zA-Z])([ <\n]|$)",
        r'\1<tt class="dotted">\2</tt>\3', translator.text)

hooks.get("css").add(lambda c, css: css.append(
    ".dotted { background: #CCC }"))

@hooks.add_to("menu", after="HTTP.fy_http_help")
def display_toggle_tr_dotted(context, html):
    s = '<li><a href="?tr_dotted='
    if getattr(context, 'no_tr_dotted', False):
        s += '1">Enable'
    else:
        s += '0">Disable'
    html.append(s + ' translate dotted</a>')

@hooks.add_to("url", before="*")
def toggle_tr_dotted(context, server):
    tr_dotted = server.get_action('tr_dotted')
    if tr_dotted is not None:
        context.no_tr_dotted = tr_dotted == "0"
