"""
Add the language translator in the tip
"""
import importlib
import sys
try:
    import urllib.request as urllib2
except ImportError:
    import urllib2
import hooks

@hooks.add_to("translator_text", before="*")
@hooks.add_to("translator_html", before="*")
def store_untranslated(context, translator):
    context.untranslated = translator.text

@hooks.add_to("tip", before="*")
def store_untranslated_save(context, dummy_translator):
    context.untranslated_save = context.untranslated

@hooks.add_to("tip", after="HTTP.fy_tr_tip")
def languages(context, server):
    m = importlib.import_module(server.tip_functionality)
    tr = m.__dict__.get("translations", None)
    if tr is None:
        server.tip.append('No translation defined')
        return
    for text, translations in tr:
        if text == context.untranslated_save:
            t = ['<table border><tr><th>&nbsp;<th>Type here</tr>']
            for lang in context.languages:
                t.append('<tr><th>%s<td><textarea onblur="update_translation(event,\'%s\',\'%s\',\'%s\')">%s</textarea></tr>'
                         % (lang, lang, server.tip_functionality, hash(text),
                            translations.get(lang, '')))
            
            t.append("</table>")
            server.tip.append_raw(''.join(t).replace('{}', '{{}}'))
            break

hooks.get("js").add(lambda context, js: js.append(r"""
function update_translation(event, lang, fy, text)
{
   event = event || window.event ;
   var img = document.createElement('IMG') ;
   img.style = "height:1em" ;
   img.src = '%s/media/translate/' + lang + '/' + fy + '/' + text + '/'
        + event.target.value.replace(RegExp("/","g"), "_") ;
   event.target.parentNode.appendChild(img) ;
   setTimeout("window.location = window.location", 200) ;
}
""" % context.top))

@hooks.add_to("media")
def save_translation(context, server):
    name = server.get_parameter('/translate/')
    if not name:
        return
    server.send_response(200)
    server.send_header('Content-Type', 'image/gif')
    server.end_headers()
    lang, fy, text, value = name.split('/')
    value = urllib2.unquote(value)
    text = int(text)
    for t, translations in sys.modules[fy].__dict__["translations"]:
        if hash(t) == text:
            translations[lang] = value
            hooks.get("reload")(context, 'translation')
            break
    server.write('GIF87a\x01\x00\x01\x00\x80\x01\x00\x1e\xff\x00\xff\xff\xff,\x00\x00\x00\x00\x01\x00\x01\x00\x00\x02\x02D\x01\x00;')
    return True
