"""
Allow to set the HTTP port from the command line.
"""
import hooks

@hooks.add_to("args", before="HTTP.fy_http")
def option_server_port(context):
    context.port = int(context.extract_arg("--port=") or 1234)

@hooks.add_to("help", after="HTTP.fy_http")
def server_port_help(dummy_context, messages):
    messages.append("--port=9999: set the HTTP server port number")
