"""
Create a media javascript and add it to the web page using 'js' hook.
On functionality reload the JS file is updated.
"""
import time
import hooks

js = hooks.new("js",
               "Append your JavaScript code to list_of_js",
               args=('context', 'list_of_js'))

@hooks.add_to("media")
def send_js(context, server):
    if not server.path.startswith('/style.js'):
        return
    if not getattr(context, 'js_string', ''):
        js_list = []
        js(context, js_list)
        context.js_string = '\n'.join(js_list)
    server.send_response(200)
    server.send_header('Content-Type', 'application/javascript;charset=UTF-8')
    server.send_header('Cache-Control', 'max-age=86400')
    server.end_headers()
    server.write(context.js_string)
    return True

@hooks.add_to("menu", before="HTTP.fy_http_home", after="HTTP.fy_css")
def js_link(context, html):
    if not hasattr(context, 'js_version'):
        context.__class__.js_version = int(time.time())
    html.content.append('<script src="%s/media/style.js/%d"></script>\n'
                        % (context.top, context.js_version))

@hooks.add_to("reload")
def clear_cache(context, dummy_fy):
    context.__class__.js_string = ''
    context.__class__.js_version += 1
