"""
Display running threads
"""
import sys
import threading
import traceback
import cgi
import hooks

@hooks.add_to("menu", after="HTTP.fy_http_stats")
def link_to_threads(dummy_context, html):
    html.append('<li><a href="/threads">Display threads</a>')

@hooks.add_to("url")
def thread_page(context, server):
    if server.path != '/threads':
        return
    server.write(server.eval_menu())
    html = context.Translator(server.translate)
    me = threading.current_thread()
    for thread in threading.enumerate():
        if thread is me:
            color = ";color:#888"
        else:
            color = ""
        html.append(
            '<pre style="border: 1px solid black%s">' % color
            + cgi.escape(''.join(
                traceback.format_stack(sys._current_frames()[thread.ident])))
            + '</pre>'
            )
    server.write('\n'.join(html))
    return True


