"""
Display statistics.
"""
import hooks

menu = hooks.get("menu")

@menu.add(after="HTTP.fy_http_hooks")
def link_to_stats(dummy_context, html):
    html.append('<li><a href="/stats">Display stats</a>')

stats = hooks.new("stats",
                  "Append statistics page HTML content into translator",
                  args=('context', 'translator'))

@hooks.add_to("url")
def display_stats(context, server):
    if not server.path.startswith("/stats"):
        return
    server.write(server.eval_menu())
    html = context.Translator(server.translate)
    stats(context, html)
    server.write(''.join(html))
    return True
