"""
If the URL is not trapped by the 'media' hook,
the HTTP header is sent with text/html mime type.
"""
import hooks

media = hooks.new(
    "media",
    "Parse server.path, write the page content with server.write()",
    args=('context', 'server')
)

@hooks.add_to("url", before="*")
def send_media(context, server):
    fy = server.path.startswith('/media/')
    found = False
    if fy:
        server.path = server.path.split('/media')[1]
        found = media(context, server)
    if found:
        return True
    else:
        server.send_response(200)
        server.send_header('Content-Type', 'text/html;charset=UTF-8')
        server.end_headers()
        if fy:
            server.write(server.translate_html("Unknown media"))
            return True

