"""
Set the language from the web interface.
"""
import hooks

@hooks.add_to("menu")
def menu(context, html_list):
    s = '<li> Set language: '
    for lang in sorted(context.languages):
        if lang == context.language:
            html = ' class="selected"'
        else:
            html = ''
        s += ' <a%s href="?language=%s">%s</a>' % (html, lang, lang)
    html_list.append(s)

@hooks.add_to("url", before="*")
def language(context, server):
    if '?language=' not in server.path:
        return
    server.path, context.language = server.path.split('?language=')
