"""
Display the dependencies graph
"""
import hooks
import subprocess

@hooks.add_to("menu")
def link_to_help(dummy_context, html):
    html.append('<li><a href="/graph">Dependencies graph</a>')

@hooks.add_to("url")
def html_dependencies(context, server):
    if server.path != '/graph':
        return
    server.write(server.eval_menu())
    t = context.Translator(server.translate)
    t.append('<img src="/media/graph.png">')
    server.write(''.join(t))
    return True

@hooks.add_to("media")
def html_dependencies_png(dummy_context, server):
    if server.path != '/graph.png':
        return
    f = open("xxx.dot", "w")
    f.write(dot())
    f.close()
    p = subprocess.Popen(["neato", "-Tpng", "-Gmaxiter=100000",
                          "xxx.dot"], stdout=subprocess.PIPE)
    server.send_response(200)
    server.send_header('Content-Type', 'image/png')
    server.end_headers()
    server.wfile.write(p.communicate()[0])
    return True

def dot():
    t = ['digraph "FyHooks" {splines=curved;']
    t.append('node[shape=rectangle,fontsize="10"];')
    t.append('edge[len="5"];')
    fys = hooks.functionalities()
    main = hooks.get('init').functionality
    if main not in fys:
        fys[main] = []
    for fy, hook_fcts in fys.items():
        s = '"%s" [ shape=none,label=<<TABLE BORDER="0" CELLBORDER="1" CELLSPACING="0"><TR><TD PORT="FFF%s" BGCOLOR="#80FF80">%s</TD></TR>' % (
            fy, fy, fy.replace(".","<BR/>"))
        for hook in hooks.hooks.hooks.values():
            if hook.functionality == fy:
                s +=  '<TR><TD PORT="%s" BGCOLOR="#FFFF80">%s</TD></TR>' % (hook.name, hook.name)
        for hook, fcts in hook_fcts:
            for fct in fcts:
                s += '<TR><TD PORT="%s">%s</TD></TR>' % (fct.name, fct.name)
        s += '</TABLE>>] ;'
        t.append(s)
    for fy, hook_fcts in hooks.functionalities().items():
        for hook, fcts in hook_fcts:
            for fct in fcts:
                for before in fct.before:
                    if '*' in before:
                        continue
                    before = before.replace(':', '":"')
                    t.append('"%s":"%s" -> "%s" [ label="before" ] ;' % (
                        fct.functionality, fct.name, before))
                for after in fct.after:
                    if '*' in after:
                        continue
                    after = after.replace(':', '":"')
                    t.append('"%s" -> "%s":"%s" [ label="not after" ] ;'
                             % (after, fct.functionality, fct.name))
                t.append('"%s":"%s" -> "%s":"%s" [ color="#808080" ] ;' % (
                    hook.functionality, hook.name, fct.functionality, fct.name))
    t.append("}")
    return '\n'.join(t)

@hooks.add_to("args")
def args(context):
    if context.extract_arg("--dot"):
        print(dot())

@hooks.add_to("help", after="fy_debug")
def help(dummy_context, messages):
    messages.append("--dot: Dependencies graph as a DOT file")
