"""
Display a page with all the functionalities.
"""
import hooks

columns = hooks.new(
    "fy_http_columns",
    "The server.functionality_list contains functionality names.\n"
    "The function append an HTML list to server.html_columns\n"
    "The first item of the input/output list is the column name.",
    args=('context', 'server')
)

def display_functionalities(context, server):
    server.write(server.eval_menu())
    server.functionality_list = ('Display details',
                                 ) + tuple(hooks.functionalities().keys())
    server.html_columns = []
    columns(context, server)
    server.html_columns.insert(0, server.functionality_list)
    t = context.Translator(server.translate)
    t.append_raw('<table border>')
    for row in zip(*server.html_columns):
        t.append_raw('<tr><td>')
        t.append(row[0])
        t.append_raw(''.join("<td>%s" % cell
                             for cell in row[1:]))
        t.append_raw("</tr>")
    t.append_raw("</table>")
    server.write('\n'.join(t))
    
@hooks.add_to("url")
def list_functionalities(context, server):
    server.display_functionalities = display_functionalities
    if server.path != '/functionalities':
        return
    display_functionalities(context, server)
    return True

@hooks.add_to("menu")
def menu(dummy_context, html):
    html.append('<li><a href="/functionalities">Functionalities</a>')
