"""
Display hooks details
"""
import hooks

columns = hooks.new(
    "fy_hooks_columns",
    "The server.function_list contains Function objects.\n"
    "The function append an HTML list to server.hooks_columns\n"
    "The first item of the input/output list is the column name."
    "server.hook is the current displayed hook",
    args=("context", "server")
)

@columns.add
def add_function_column(dummy_context, server):
    server.hooks_columns.append(
        ['Function'] + [f.name for f in server.function_list[1:]])

@columns.add(after="HTTP.fy_hooks:add_function_column")
def add_functionality_column(context, server):
    t = context.Translator(server.translate)
    server.hooks_columns.append(['Functionality']
                                + [t.translate(f.functionality)
                                   for f in server.function_list[1:]])

@columns.add(after="HTTP.fy_hooks:add_functionality_column")
def add_before_column(context, server):
    t = context.Translator(server.translate)
    server.hooks_columns.append(['Before']
                                + [' '.join(t.translate(x)
                                            for x in f.before) + '&nbsp;'
                                   for f in server.function_list[1:]])

@columns.add(after="HTTP.fy_hooks:add_before_column")
def add_after_column(context, server):
    t = context.Translator(server.translate)
    server.hooks_columns.append(['After']
                                + [' '.join(t.translate(x)
                                            for x in f.after) + '&nbsp;'
                                   for f in server.function_list[1:]])

@columns.add(after="HTTP.fy_hooks:add_after_column")
def add_priority_column(dummy_context, server):
    server.hooks_columns.append(['Priority']
                                + [str(f.priority or '&nbsp;')
                                   for f in server.function_list[1:]])

@hooks.add_to("url", after="HTTP.fy_http_hooks")
def url_hook_detail(context, server):
    name = server.get_parameter('/hooks/')
    if not name:
        return
    server.write(server.eval_menu())
    server.display_hooks(context, server)
    hook = hooks.get(name)
    hook.sort()

    server.function_list = [''] + hook.functions
    server.hook = hook
    server.hooks_columns = [
        [''] + ['%4d' % i for i in range(len(hook.functions))]]
    columns(context, server)
    
    t = ['<table border>']
    lines = iter(zip(*server.hooks_columns))
    t.append('<tr>' + ''.join('<th>' + cell
                              for cell in next(lines))
             + '</tr>')
    for line in lines:
        t.append('<tr>' + ''.join('<td>' + cell for cell in line) + '</tr>')
    t.append("</table>")
    server.write('\n'.join(t))
    return True
