"""
Add a column on the functionality web page to enable/disable functionalities
"""
import hooks

@hooks.add_to("url", before="*")
def toggle_functionality(context, server):
    fy = server.get_action('toggle')
    if not fy:
        return
    if hooks.is_enabled(fy):
        hooks.disable(fy)
    else:
        hooks.enable(fy)
    context.reloaded = fy
    hooks.get("reload")(context, fy)

@hooks.add_to("fy_http_columns")
def toggle_column(dummy_context, server):
    server.html_columns.append([''] + [
        '<a href="?toggle=%s">%s</a>' % (
            fy, 'Disable' if hooks.is_enabled(fy) else 'Enable')
        for fy in server.functionality_list[1:]])
