"""
Add a reload column on the page displaying functionalities.
"""
import hooks

reload = hooks.new(
    "reload",
    "Called when a Python module has been reloaded.",
    args=("context", "reloaded_functionality_name"))

@hooks.add_to("url", before="*")
def reload_functionality(context, server):
    fy = server.get_action('reload')
    if not fy:
        return
    hooks.reload(fy)
    reload(context, fy)

@hooks.add_to("fy_http_columns")
def reload_column(dummy_context, server):
    server.html_columns.append([''] + [
        '<a href="?reload=%s">Reload</a>' % fy
        for fy in server.functionality_list[1:]])
