"""
Add a 'documentation' column on the page displaying functionalities.
"""
import sys
import hooks

@hooks.add_to("fy_http_columns")
def doc_column(dummy_context, server):
    server.html_columns.append(['Module documentation'] + [
        str(sys.modules[fy].__doc__).strip().replace('\n', '<br>')
        for fy in server.functionality_list[1:]])
