"""
Create a media CSS style and add it to the web page using 'css' hook.
On functionality reload the CSS file is updated.
"""
import time
import hooks

css = hooks.new("css",
                "Append your CSS code to list_of_css",
                args=("context", "list_of_css"))

@hooks.add_to("media")
def send_css(context, server):
    if not server.path.startswith('/style.css'):
        return
    if not getattr(context, 'css_string', ''):
        css_list = ['BODY { margin-top: 0px }']
        css(context, css_list)
        context.__class__.css_string = '\n'.join(css_list)
    server.send_response(200)
    server.send_header('Content-Type', 'text/css;charset=UTF-8')
    server.send_header('Cache-Control', 'max-age=86400')
    server.end_headers()
    server.write(context.css_string)
    return True

@hooks.add_to("menu", before='HTTP.fy_http_home') # XXX before="**" ?
def css_link(context, html):
    if not hasattr(context, 'css_version'):
        context.__class__.css_version = int(time.time())
    html.append_raw(
        '<!DOCTYPE html>\n'
        '<html>\n'
        '<head>\n'
        '<link rel="stylesheet" href="%s/media/style.css/%d" type="text/css">\n'
        % (context.top, context.css_version)
        + '</head>\n'
        '<body>')

@hooks.add_to("reload")
def clear_cache(context, dummy_fy):
    context.__class__.css_string = ''
    context.__class__.css_version += 1
