"""
The object graph
"""
import gc
from . import objgraph
import hooks

@hooks.add_to("about", after="GC.fy_about_str")
def about_graph(context, dummy_server, obj, html):
    html.append('<h1>Graph of instances</h1>')
    s = 'Graph depth:'
    context.graph_depth = getattr(context, 'graph_depth', 1)
    for d in range(5):
        if d == context.graph_depth:
            sel = ' class="selected"'
        else:
            sel = ''
        s += ' <a%s href="?graph_depth=%s">%s</a>' % (sel, d, d)
    html.append(s)

    html.append('<h2>Back references</h2>'
                '<img src="/media/backrefs/%s">' % id(obj))
    html.append('<h2>Forward references</h2>'
                '<img src="/media/refs/%s">' % id(obj))

def graph(context, server, fct, name):
    obj_id = server.get_parameter('/' + name + '/')
    if not obj_id:
        return
    obj = objgraph.at(int(obj_id))
    filename = "xxx.png"
    gc.collect()
    context.graph_depth = getattr(context, 'graph_depth', 1)
    fct(obj, max_depth=context.graph_depth, too_many=10, filename=filename)
    f = open(filename, 'rb')
    c = f.read()
    f.close()

    server.send_response(200)
    server.send_header('Content-Type', 'image/png')
    server.end_headers()
    server.wfile.write(c)
    return True

@hooks.add_to("media")
def backref(context, server):
    return graph(context, server, objgraph.show_backrefs, 'backrefs')

@hooks.add_to("media")
def ref(context, server):
    return graph(context, server, objgraph.show_refs, 'refs')

@hooks.add_to("url", before="*")
def set_graph_depth(context, server):
    if '?graph_depth=' not in server.path:
        return
    server.path, context.graph_depth = server.path.split('?graph_depth=')
    context.graph_depth = int(context.graph_depth)
