"""
Server to evaluate formula.
"""
import socket
import select
import hooks
port = 1235
def calc(context):
    context.calc_socket = socket.socket()
    context.calc_socket.bind(('127.0.0.1', port))
    context.calc_socket.listen(5)
    poll = select.poll()
    read = select.POLLIN | select.POLLPRI | select.POLLHUP | select.POLLERR
    poll.register(context.calc_socket, read)
    fd_to_socket = { context.calc_socket.fileno(): context.calc_socket }
    print("Calculator running on socket port %s" % port)
    while True:
        events = poll.poll(1000000)
        for fd, dummy_flags in events:
            if fd == context.calc_socket.fileno():
                ss, who = context.calc_socket.accept()
                ss.send(("Welcome to calculator %s.\n" % repr(who)
                     ).encode('utf-8'))
                fd_to_socket[ss.fileno()] = ss
                poll.register(ss, read)
            else:
                ss = fd_to_socket[fd]
                formula = ss.recv(1000000).decode("utf-8").strip()
                if formula == 'exit':
                    for f in fd_to_socket.values():
                        f.shutdown(socket.SHUT_RDWR)
                        f.close()
                    context.calc_socket = None
                    return
                result = context.calc_eval(formula)
                try:
                    ss.send((repr(result) + '\n').encode("utf-8"))
                except socket.error:
                    poll.unregister(ss)
                    ss.close()
                    del fd_to_socket[fd]

@hooks.add_to("args")
def args(context):
    if context.extract_arg('--calc-socket'):
        hooks.add_to("thread", calc)

@hooks.add_to("help", after="CALC.fy_calc")
def help(dummy_context, messages):
    messages.append(
        "--calc-socket: The server on the port %d evaluate the formula" % port)
