"""
Add an extensible calculator
"""
import types
import hooks

calc = hooks.new("calc",
                 "The list of values must be evaluated",
                 args=('context', 'list_of_values'))

def parse_numbers(formula):
    f = []
    number = None
    for c in formula:
        if c.isdigit():
            if number is None:
                number = 0
            number = number*10 + int(c)
        else:
            if number is not None:
                f.append(number)
            f.append(c)
            number = None
    if number is not None:
        f.append(number)
    return f

def calc_eval(self, formula):
    formula = parse_numbers(formula)
    while True:
        length = len(formula)
        calc(self, formula)
        if length == len(formula):
            return formula

@hooks.add_to("args")
def args(context):
    context.calc_eval = types.MethodType(calc_eval, context)
    while True:
        formula = context.extract_arg("--calc=")
        if not formula:
            return
        print(context.calc_eval(formula))

@hooks.add_to("help")
def help(dummy_context, messages):
    messages.append(
        "\n"
        "Calculator:\n"
        "--calc=formula: +-*/() on integers")


