#include <dlfcn.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <dirent.h>

#include "hooks.h"
#include "fy_args.h"

void load_functionality(const char *filename)
{
  void *f = dlopen(filename, RTLD_NOW | RTLD_GLOBAL) ;
  if ( f == NULL )
    {
      fprintf(stderr, "%s: %s\n", filename, dlerror()) ;
      return ;
    }
  void (*s)() = dlsym(f, "fy_init") ;
  if ( s )
    {
      s() ;
    }
}

void load_all()
{
  DIR *f = opendir(".") ;
  struct dirent *d ;
  for(;;)
    {
      d = readdir(f) ;
      if ( ! d )
	break ;
      if ( d->d_name[strlen(d->d_name)-1] == 'o'
	   && strncmp(d->d_name, "fy_", 3) == 0
	   )
	{
	  char *tmp = malloc(strlen(d->d_name) + 3) ;
	  sprintf(tmp, "./%s", d->d_name) ;
	  load_functionality(tmp) ;
	  free(tmp) ;
	}
    }
  closedir(f) ;
}

int main(int argc, char **argv)
{
  Fy_args args ;
  args.argc = argc ;
  args.argv = argv ;

  load_all() ;
  hook_call(hook_get("args"), &args) ;
  return 0 ;
}
