#include <string.h>
#include <stdlib.h>
#include "hooks.h"

#if 0
#define PRINTF printf("%p ", &hooks) , printf
#else
#define PRINTF if (0) printf
#endif

void function_display(FILE *f, Function *fct)
{
  fprintf(f, "\t\t%s:%s before=%s after=%s priority=%d\n",
	  fct->src_file, fct->name, fct->before, fct->after, fct->priority) ;
}
void hook_display(FILE *f, Hook *h) ;

struct {
  Hook *hooks ;
} hooks = {NULL} ;

Hook* hook_get(const char *name)
{
  Hook *h ;
  PRINTF("Hook_get %s\n", name) ;
  for(h=hooks.hooks ; h; h = h->next)
    if ( strcmp(h->name, name) == 0 )
      return h ;
   
  h = calloc(sizeof(*h), 1);
  h->name = name ;
  h->doc = "?" ;
  h->src_file = "?" ;
  h->src_line = "?" ;
  h->next = hooks.hooks ;
  h->nr_functions = 0 ;
  h->functions = calloc(sizeof(*h->functions) , 1) ;
  h->functions[0].name = NULL ;
  hooks.hooks = h ;
  PRINTF("Hook_get %s create stub %p\n", name, h) ;
  return h ;
}

Hook* hook_new(const char *name, const char *doc, void* (*eval)(Hook*, void*),
	       const char *src_file, const char *src_line)
{
  PRINTF("Hook_new %s\n", name) ;
  Hook *h = hook_get(name) ;
  h->doc = doc ;
  h->src_file = src_file ;
  h->src_line = src_line ;
  if ( eval )
    h->eval = eval ;
  else
    h->eval = hook_eval ;
  return h ;
}

void hook_add(Hook *hook, HookFct fct, const char *doc, const char *before_fy,
	      const char *after_fy, const char *fct_name,
	      const char *src_file, const char *src_line)
{
  PRINTF("Hook_add %s : %s %p\n", hook->name, fct_name, fct) ;
  hook->functions = realloc(hook->functions,
			    (hook->nr_functions + 2)
			    * sizeof(*hook->functions)) ;
  Function *f = &hook->functions[hook->nr_functions] ;
  f->fct = fct ;
  f->name = fct_name ;
  f->doc = doc ;
  f->before = before_fy ;
  f->after = after_fy ;
  f->src_file = src_file ;
  f->src_line = src_line ;
  f->hook = hook ;
  f->priority = 9999 ;
  hook->functions[hook->nr_functions+1].name = NULL ;
  hook->is_sorted = 0 ;
  hook->nr_functions++ ;
}

static int count(const char *txt, char c)
{
  if ( *txt )
    return ( *txt == c ) + count(txt+1, c) ;
  return 0 ;
}

// Test directly the position: no recursion
// returns 1 if 'f' is before 'g'
//        -1 if 'f' is after 'g'
//         0 if neither
static int order(const Function *f, const Function *g)
{
  if ( strcmp(f->after, g->src_file) == 0 )
     return -1 ;
  if ( strcmp(f->before, g->src_file) == 0 )
     return 1 ;
  if ( strcmp(f->src_file, g->before) == 0 )
     return -1 ;
  if ( strcmp(f->src_file, g->after) == 0 )
     return 1 ;

  return 0 ;
}

#define FOR(I, HOOK) \
  Function *I ; for(I=(HOOK)->functions ; I->name ; I++)

#define FOR_FY(I, HOOK, FY) \
  FOR(I, HOOK) if ( strcmp(I->src_file, FY) == 0 )

void hook_display(FILE *f, Hook *h)
{
  fprintf(f, "\t%s:%s\n", h->src_file, h->name) ;
  FOR(fct, h)
    function_display(f, fct) ;
}

static int placable(Hook *h, Function *f)
{
  if ( f->done )
    return 0 ;
  FOR(ff, h)
    {
      if ( ! ff->done && ( f->priority > ff->priority
			   || order(f, ff) == 1 ) )
        return 0 ;
    }
  return 1 ;
}

static void hook_sort(Hook *h)
{
  PRINTF("Hook_sort %s %d : functions : %p\n", h->name, h->is_sorted, h->functions) ;
  if ( h->is_sorted )
    return;
  FOR(f, h)
    {
      f->priority = count(f->after, '*') - count(f->before, '*') ;
    }
  int change ;
  do
    {
      change = 0 ;
      FOR(f, h)
        {
	  FOR(ff, h)
	    switch(order(f, ff))
	      {
	      case 1:
		if ( f->priority > f->priority )
		  {
		    f->priority = ff->priority ;
		    change = 1 ;
		  }
		break ;
	      case -1:
		if ( f->priority < f->priority )
		  {
		    f->priority = ff->priority ;
		    change = 1 ;
		  }
		break ;
	      }
	}
    }
  while(change) ;
  int i ;
  for(i=0; i < h->nr_functions; i++)
     h->functions[i].done = 0 ;
  h->sorted = realloc(h->sorted, (h->nr_functions+1) * sizeof(*h->sorted)) ;
  i = 0 ;
  do
    {
      change = 0 ;
      FOR(f, h)
        {
          if ( ! f->done && placable(h, f) )
            {
	      PRINTF("Placable %s %s\n", h->name, f->name) ;
              change = 1 ;
              h->sorted[i++] = f ;
              f->done = 1 ;
            }
        }
    }
  while(change) ;
  if ( i != h->nr_functions )
    {
      fprintf(stderr, "Unsorted (i=%d h->nr_functions=%d) :\n",
	      i, h->nr_functions) ;
      FOR(f, h)
        if ( ! f->done && ! placable(h, f) )
           function_display(stderr, f) ;
      printf("==================\n") ;
      hook_display(stdout, h) ;
      printf("==================\n") ;
    }
  h->sorted[i++] = NULL ;
  h->is_sorted = 1 ;
}

void hook_display_sorted(FILE *f, Hook *h)
{
  fprintf(f, "\t%s:%s\n", h->src_file, h->name) ;
  Function **fct ;
  hook_sort(h) ;
  for(fct = h->sorted; *fct ; fct++)
    function_display(f, *fct) ;
}

void hooks_display(FILE *f)
{
  Hook *h ;
  for(h=hooks.hooks ; h; h = h->next)
    {
      hook_display_sorted(f, h) ;
    }
}

void* hook_call(Hook *h, void *context)
{
  PRINTF("Hook_call %s\n", h->name) ;
  hook_sort(h) ;
  return h->eval(h, context) ; 
}

void* hook_eval(Hook *h, void *context)
{
  Function **f ;
  PRINTF("Hook_eval %s %p\n", h->name, h->sorted) ;
  void *result = NULL ;
  for(f = h->sorted; *f && result == NULL ; f++)
    result = (*f)->fct(context) ;
  return result ;
}



struct data {
  const char *name ;
  void *data ;
  struct data *next ;
} *data = NULL ;

void **get_data(const char *name)
{
  struct data *d ;
  for(d=data ; d; d = d->next)
    if ( strcmp(d->name, name) == 0 )
      return &d->data ;
   
  d = calloc(sizeof(*d), 1);
  d->name = strdup(name) ;
  return &d->data ;
}


