#include "hooks.h"
#include "fy_args.h"

static void *help_eval(Hook *h, void *context)
{
  Function **f ;
  for(f = h->sorted; *f ; f++)
    printf("%s\n", (char*)(*f)->fct(context)) ;
  return NULL ;
}

#define HELP "--help: Display the help"

static void *message(void *unused_context)
{
  return HELP ;
}

static void *args_help(Fy_args *args)
{
  int i = args->find(args, "--help") ;
  if ( i )
    {
      hook_call(hook_get("help"), args) ;
      args->remove(args, i) ;
    }
  return NULL ;
}

void fy_init()
{
  Hook *h = HOOK_NEW("help", "", help_eval) ;
  HOOK_ADD(h, message, HELP, "", "") ;
  HOOK_ADD(hook_get("args"), args_help, HELP, "", "") ;
}
