#include "hooks.h"
#include "fy_args.h"

static void* display(Fy_args *args)
{
  int i = args->find(args, "--dump-hooks") ;
  if ( i )
    {
      hooks_display(stdout) ;
      args->remove(args, i) ;
    }
  return NULL ;
}

#define HELP "--dump-hooks: Display hooks"

static void* message()
{
  return HELP ;
}

void fy_init()
{
  HOOK_ADD(hook_get("args"), display, HELP, "", "") ;
  HOOK_ADD(hook_get("help"), message, HELP, "", "") ;
}

