"""
Compute primes in a separate process managed by asyncio
"""
import sys

if __name__ == '__main__':
    def is_prime(i):
        j = 2
        while j < i:
            if i % j == 0:
                return
            j += 1
        return True

    i = 1000000
    while i:
        if is_prime(i):
            print('prime:%d' % i)
            sys.stdout.flush()
        i += 1

import asyncio
import hooks

def asyncio_primes(context):
    loop = asyncio.get_event_loop()
    exit_future = asyncio.Future(loop=loop)

    class PrimeProtocol(asyncio.SubprocessProtocol):
        def __init__(self, exit_future):
            self.exit_future = exit_future

        def pipe_data_received(self, fd, data):
            print(data)

        def process_exited(self):
            self.exit_future.set_result(True)

    create = loop.subprocess_exec(lambda: PrimeProtocol(exit_future),
                                  sys.executable, # Python interpreter
                                  'ASYNC/fy_primes_process.py',
                                  stdin=None, stderr=None)
    transport, protocol = yield from create
    # Wait for the subprocess exit using the process_exited() method
    # of the protocol
    yield from exit_future
    # Close the stdout pipe
    transport.close()

@hooks.add_to("args")
def args(context):
    if context.extract_arg("--primes-process"):
        hooks.add_to("asyncio", asyncio_primes)

@hooks.add_to("help", after="fy_primes")
def help(dummy_context, messages):
    messages.append("--primes-process: computes primes in a separate process")
