"""
Server to evaluate formula.
"""
import asyncio
import hooks
port = 1236

def calc(context):
    class CalcProtocol:
        def connection_made(self, transport):
            print('async calc socket open')
            self.transport = transport
            self.transport.write(("Welcome to calculator %s.\n"
                                  % repr(transport)).encode('utf-8'))
        def data_received(self, formula):
            if formula.strip() == b'exit':
                server.close()
                self.transport.close()
                return
            result = context.calc_eval(formula.strip().decode('utf-8'))
            self.transport.write(str(result).encode('utf-8'))
        def connection_lost(self, exc):
            print('async calc socket close')
        def eof_received(self):
            print('async calc socket eof')
    print('async calc socket begin')
    loop = asyncio.get_event_loop()
    server = yield from loop.create_server(CalcProtocol, '127.0.0.1', port)
    yield from server.wait_closed()
    print('async calc socket end')

@hooks.add_to("args")
def args(context):
    if context.extract_arg('--async-calc-socket'):
        hooks.add_to("asyncio", calc)

@hooks.add_to("help", after="fy_async")
def help(dummy_context, messages):
    messages.append(
        "--async-calc-socket: The server on the port %d evaluate the formula" % port)
