"""
Print tictoc each seconds using asyncio
"""
import asyncio
import hooks

def tictoc(context):
    for i in range(10):
        print(("tic","toc")[i%2])
        for i in asyncio.sleep(1):
            yield i

@hooks.add_to("args")
def args(context):
    if context.extract_arg("--tictoc"):
        hooks.add_to("asyncio", tictoc)

@hooks.add_to("help")
def help(dummy_context, messages):
    messages.append("--tictoc: Display a tic each second using asyncio")
